require 'g_level'
g_level.reset()

--INIT TEXTURES  -- adds a texture into ObjectManager<Texture>
h = FM_NEAREST;
lua_init_texture("menu_background", "data/images/lvl_menu/menu_background.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("office", "data/images/toimisto_sisatesti.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("office2", "data/images/toimisto_sisatesti2.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("parallax_background", "data/images/clouds.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("bg_1", "data/images/lvl_forest/metsatausta.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("bg_2", "data/images/lvl_forest/metsatausta2.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)

-- Create Level
lua:create_level(1.0,1.0,1.0,1.0)   --RGBA values are given also

-- Create Layers
-- The index of the layers are auto incremented. This meaning that the first one to add is 0 and rest are in order of appearance...
lua:create_layer(0.0,0.0,BM_DEFAULT)  -- x_scroll , y_scroll, blendmode  -- 0
lua:create_layer(0.0,0.0,BM_DEFAULT) -- 1
lua:create_layer(1.0,1.0,BM_DEFAULT) -- 2
lua:create_layer(1.0,1.0,BM_DEFAULT) -- 3
lua:create_layer(0.0,0.0,BM_DEFAULT) -- 4 = dummy, for menus

-- Background starts
local background_size = 0.20
local scale = 0.5
lua:create_sprite("background", ST_TEXTURED,"parallax_background",      0.0, 100.0) 
lua:sprite_shape("background",ST_TEXTURED,                              scale *4096.0/2, scale * 1024.0/2)
lua:textured_sprite_tex_coords("background", ST_TEXTURED,               0.0, 0.0, 2.0, 1.0)
g_level.upload("background",                                            0)
-- background mountains
local bgMountainsLenght = 7.5
lua:create_sprite("background-mountains", ST_TEXTURED,"bg_1",1000.0, -200.0) -- nimi, joku, tekstuurin nimi, x, y
lua:sprite_color("background-mountains", 0.5, 0.5, 0.5 , 1.0)
lua:sprite_shape("background-mountains",ST_TEXTURED, background_size*4096.0*bgMountainsLenght, background_size*1024.0*1.5)
lua:textured_sprite_tex_coords("background-mountains", ST_TEXTURED, 0.0, -0.5, bgMountainsLenght, 1.0)
--g_level.upload("background-mountains", 1)

-- background forest
local bgForestLenght = 8.5
lua:create_sprite("background-forest", ST_TEXTURED,"bg_2", 2500.0, -400.0)
lua:sprite_color("background-forest", 0.5, 0.5, 0.5 , 1.0)
lua:sprite_shape("background-forest", ST_TEXTURED, 4096*bgForestLenght/4, 1024*1.5/4)
lua:textured_sprite_tex_coords("background-forest", ST_TEXTURED, -bgForestLenght, -0.5, 0.0, 1.0)
--g_level.upload("background-forest", 2)

-- office
local scale = 0.4
lua:create_sprite("background", ST_TEXTURED,"office2",              0.0, 10.0) 
lua:sprite_shape("background",ST_TEXTURED,                          scale * 2048.0, scale * 1024.0)
lua:textured_sprite_tex_coords("background", ST_TEXTURED,           0.0, 0.0, 1.0, 1.0)
g_level.upload("background",                                         2)
-- office
local scale = 0.4
lua:create_sprite("background", ST_TEXTURED,"office2",              -1500.0, 10.0) 
lua:sprite_shape("background",ST_TEXTURED,                          scale * 2048.0, scale * 1024.0)
lua:textured_sprite_tex_coords("background", ST_TEXTURED,           0.0, 0.0, 0.55, 1.0)
g_level.upload("background",                                         2)
-- Background ends

--segments
lua:create_segment(-1345, -207)
lua:add_segment(4095, -207)
lua:upload_segmentstrip()

--STOPPERS
stopper(LEFT,-1345) --far left
--far right
stopper(RIGHT,500.0) --id, shape, x ,y

trigger("data/scripts/dialogs/dia_talk_mother.lua","data/scripts/srt_next_level.lua",20,500,210.0,0.0)  --scriptname in, scriptname out, width,height,x,y

--Player
--INIT PLAYER
lua:do_file("data/scripts/crt_player_trigger.lua",0)
lua:init_camera_binder(-1345.0, 1800.0, -400.0, 500.0) -- left, right, bottom, up
lua:upload_player_to_layer(2)  --index of the layer
lua:creature_translation("player", CPT_PLAYER, -700.0, -40.0) -- set the player to it's right position
--Player end

lua:set_game_state(GS_PLAY) -- sets the game state to menu. thus you are able to use the menu commands
g_level.next_level = "data/scripts/lvl_tutorial.lua"


